Imports System.Data.SqlClient
Public Class Main
    ' Connection string to locate server
    Dim con As SqlConnection
    Private Sub Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Declarations
        Dim strSQLConnection As String

        ' Open SQL Server connection
        strSQLConnection = InputBox("Change connection string, if necessary", "Specify connection to server and database", "Server=(local)\SQLEXPRESS;Initial Catalog=Security Model;Integrated Security=SSPI")

        ' Connection string to locate server, database, and security 
        con = New SqlConnection(strSQLConnection)

        ' Fill User
        FillUser()

        ' Fill View
        FillView()

        ' Fill Control
        FillControl()

        ' Display message
        lblMsg_Click(sender, e)
    End Sub
    Private Sub FillUser()
        ' Declarations
        Dim str As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill lbUser
        lbUser.Items.Clear()
        cmd.CommandText = "SELECT UserName FROM lkpUser ORDER BY UserName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str = reader.Item(0).ToString
            lbUser.Items.Add(str)
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillView()
        ' Declarations
        Dim str As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lbView.Items.Clear()
        cmd.CommandText = "SELECT ViewName FROM lkpView ORDER BY ViewName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str = reader.Item(0).ToString
            lbView.Items.Add(str)
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillControl()
        ' Clear listbox
        lbControl.Items.Clear()

        ' Add names of common controls 
        For Each ctrl As Control In Me.Controls
            ' If this is one of the following controls
            If (TypeOf ctrl Is TextBox) Or _
            (TypeOf ctrl Is Button) Or _
            (TypeOf ctrl Is ListBox) Or _
            (TypeOf ctrl Is ListView) Then
                lbControl.Items.Add(ctrl.Name.ToString)
            End If
        Next

        ' Sort listbox
        lbControl.Sorted = True
    End Sub
    Private Sub FillResult()
        ' Declarations
        Dim str(16) As String
        Dim cmd As New SqlCommand("", con)
        Dim prmUser As SqlClient.SqlParameter
        Dim prmView As SqlClient.SqlParameter

        ' Define parameters for stored proc
        prmUser = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prmUser.Value = lbUser.SelectedItem.ToString
        prmView = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prmView.Value = lbView.SelectedItem.ToString

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqMain"
        cmd.Parameters.Add(prmUser)
        cmd.Parameters.Add(prmView)

        ' Clear items from result box
        lvEmployee.Items.Clear()

        ' Open connection
        con.Open()

        ' Fill result box
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            str(2) = reader.Item(2).ToString
            str(3) = reader.Item(3).ToString
            str(4) = reader.Item(4).ToString
            str(5) = reader.Item(5).ToString
            str(6) = reader.Item(6).ToString
            str(7) = reader.Item(7).ToString
            str(8) = reader.Item(8).ToString
            str(9) = reader.Item(9).ToString
            str(10) = reader.Item(10).ToString
            lvEmployee.Items.Add(New ListViewItem(New String() {str(0), str(1), str(2), str(3), str(4), str(5), str(6), str(7), str(8), str(9), str(10)}))
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub lvEmployee_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvEmployee.Click
        ' Populate text boxes using selected Employee
        tbEmployeeId.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(0).Text
        tbLastName.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(1).Text
        tbFirstName.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(2).Text
        tbAddress.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(3).Text
        tbCity.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(4).Text
        tbPostal.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(5).Text
        tbProv.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(6).Text
        tbPhone.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(7).Text
        tbEmail.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(8).Text
        tbBirthDate.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(9).Text
        tbSIN.Text = lvEmployee.SelectedItems.Item(0).SubItems.Item(10).Text

        ' Enable update/delete labels
        lblUpdateRecord.Enabled = True
        lblInsertRecord.Enabled = True
        lblDeleteRecord.Enabled = True
    End Sub
    Private Sub lblParameterTables_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblParameterTables.Click
        ' Refresh parameter tables
        FillUser()
        FillView()
    End Sub
    Private Sub lblParameterTables_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblParameterTables.MouseHover
        ttlblParameterTables.SetToolTip(lblParameterTables, "Refresh all parameter tables")
    End Sub
    Private Sub lblEmployee_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblEmployee.Click
        ' Insure that parameter values have been selected for stored proc
        If lbUser.SelectedItems.Count = 0 Then
            MsgBox("Must choose User")
            Exit Sub
        End If

        If lbView.SelectedItems.Count = 0 Then
            MsgBox("Must choose View")
            Exit Sub
        End If

        ' Fill result box
        FillResult()
    End Sub
    Private Sub lblEmployee_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles lblEmployee.MouseUp
        ' Display number of records
        tbEmployeeCount.Text = lvEmployee.Items.Count
    End Sub
    Private Sub lblEmployee_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblEmployee.MouseHover
        ttlblEmployee.SetToolTip(lblEmployee, "List employees for selected parameters")
    End Sub
    Private Sub lblUpdateRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUpdateRecord.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim rv As Integer

        Dim prm0 As SqlClient.SqlParameter
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim prm4 As SqlClient.SqlParameter
        Dim prm5 As SqlClient.SqlParameter
        Dim prm6 As SqlClient.SqlParameter
        Dim prm7 As SqlClient.SqlParameter
        Dim prm8 As SqlClient.SqlParameter
        Dim prm9 As SqlClient.SqlParameter
        Dim prm10 As SqlClient.SqlParameter
        Dim prm11 As SqlClient.SqlParameter
        Dim prm12 As SqlClient.SqlParameter

        ' Define parameters for stored proc
        prm0 = New SqlClient.SqlParameter("@EmployeeId", SqlDbType.Int)
        prm1 = New SqlClient.SqlParameter("@LastName", SqlDbType.VarChar)
        prm2 = New SqlClient.SqlParameter("@FirstName", SqlDbType.VarChar)
        prm3 = New SqlClient.SqlParameter("@Address", SqlDbType.VarChar)
        prm4 = New SqlClient.SqlParameter("@City", SqlDbType.VarChar)
        prm5 = New SqlClient.SqlParameter("@Postal", SqlDbType.VarChar)
        prm6 = New SqlClient.SqlParameter("@Prov", SqlDbType.VarChar)
        prm7 = New SqlClient.SqlParameter("@Phone", SqlDbType.VarChar)
        prm8 = New SqlClient.SqlParameter("@Email", SqlDbType.VarChar)
        prm9 = New SqlClient.SqlParameter("@BirthDate", SqlDbType.VarChar)
        prm10 = New SqlClient.SqlParameter("@SIN", SqlDbType.VarChar)
        prm11 = New SqlClient.SqlParameter("@ERROR_MESSAGE", SqlDbType.VarChar)
        prm11.Direction = ParameterDirection.InputOutput
        prm12 = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        prm12.Direction = ParameterDirection.InputOutput

        ' Set parameters for stored proc
        prm0.Value = Val(tbEmployeeId.Text)
        prm1.Value = tbLastName.Text
        prm2.Value = tbFirstName.Text
        prm3.Value = tbAddress.Text
        prm4.Value = tbCity.Text
        prm5.Value = tbPostal.Text
        prm6.Value = tbProv.Text
        prm7.Value = tbPhone.Text
        prm8.Value = tbEmail.Text
        If tbBirthDate.Text = "" Then
            prm9.Value = "1900-01-01"
        Else
            prm9.Value = tbBirthDate.Text
        End If
        prm10.Value = tbSIN.Text
        prm11.Value = ""
        prm12.Value = 0

        ' Set up command to call stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "spEmployeeUpdate"
        cmd.Parameters.Add(prm0)
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(prm4)
        cmd.Parameters.Add(prm5)
        cmd.Parameters.Add(prm6)
        cmd.Parameters.Add(prm7)
        cmd.Parameters.Add(prm8)
        cmd.Parameters.Add(prm9)
        cmd.Parameters.Add(prm10)
        cmd.Parameters.Add(prm11)
        cmd.Parameters.Add(prm12)

        ' Open connection
        con.Open()

        ' Execute stored proc
        rv = cmd.ExecuteNonQuery()

        ' Process any errors
        If rv = 0 Then
            MsgBox("Failed")
        Else
            con.Close()
            If (lbUser.SelectedItems.Count > 0) And (lbView.SelectedItems.Count > 0) Then
                FillResult()
            End If
            Exit Sub
        End If

        ' Close connection
        con.Close()

    End Sub
    Private Sub lblUpdateRecord_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUpdateRecord.MouseHover
        ttlblUpdateRecord.SetToolTip(lblUpdateRecord, "Update selected employee")
    End Sub
    Private Sub lblMsg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblMsg.Click
        ' Display notes 
        Dim strMsg(8) As String ' Number of lines
        Dim I As Integer
        tbMsg.Clear()
        strMsg(0) = "NOTES" & vbCrLf & vbCrLf
        strMsg(1) = "Select User and View (click Parameters to refresh User and View, if necessary)" & vbCrLf
        strMsg(2) = "Click Employees to display result" & vbCrLf
        strMsg(3) = "Select employee to fill in fields" & vbCrLf
        strMsg(4) = "Edit fields, and then click Update/Insert/Delete to modify database" & vbCrLf
        strMsg(5) = "Click Test Security to test security on any User and View" & vbCrLf
        strMsg(6) = "Use Common Controls to copy control names to paste into Security Model" & vbCrLf
        strMsg(7) = "Click Parameters to refresh User and Views (if necessary)" & vbCrLf
        For I = 0 To 7 ' Number of lines - 1
            tbMsg.AppendText(strMsg(I))
        Next I
    End Sub
    Private Sub lblInsertRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblInsertRecord.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim rv As Integer
        Dim prm0 As SqlClient.SqlParameter
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim prm4 As SqlClient.SqlParameter
        Dim prm5 As SqlClient.SqlParameter
        Dim prm6 As SqlClient.SqlParameter
        Dim prm7 As SqlClient.SqlParameter
        Dim prm8 As SqlClient.SqlParameter
        Dim prm9 As SqlClient.SqlParameter
        Dim prm10 As SqlClient.SqlParameter
        Dim prm11 As SqlClient.SqlParameter

        ' Define parameters for stored proc
        prm0 = New SqlClient.SqlParameter("@LastName", SqlDbType.VarChar)
        prm1 = New SqlClient.SqlParameter("@FirstName", SqlDbType.VarChar)
        prm2 = New SqlClient.SqlParameter("@Address", SqlDbType.VarChar)
        prm3 = New SqlClient.SqlParameter("@City", SqlDbType.VarChar)
        prm4 = New SqlClient.SqlParameter("@Postal", SqlDbType.VarChar)
        prm5 = New SqlClient.SqlParameter("@Prov", SqlDbType.VarChar)
        prm6 = New SqlClient.SqlParameter("@Phone", SqlDbType.VarChar)
        prm7 = New SqlClient.SqlParameter("@Email", SqlDbType.VarChar)
        prm8 = New SqlClient.SqlParameter("@BirthDate", SqlDbType.VarChar)
        prm9 = New SqlClient.SqlParameter("@SIN", SqlDbType.VarChar)
        prm10 = New SqlClient.SqlParameter("@ERROR_MESSAGE", SqlDbType.VarChar)
        prm10.Direction = ParameterDirection.InputOutput
        prm11 = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        prm11.Direction = ParameterDirection.InputOutput

        ' Set parameters for stored proc

        prm0.Value = tbLastName.Text
        prm1.Value = tbFirstName.Text
        prm2.Value = tbAddress.Text
        prm3.Value = tbCity.Text
        prm4.Value = tbPostal.Text
        prm5.Value = tbProv.Text
        prm6.Value = tbPhone.Text
        prm7.Value = tbEmail.Text
        If tbBirthDate.Text = "" Then
            prm8.Value = "1900-01-01"
        Else
            prm8.Value = tbBirthDate.Text
        End If
        prm9.Value = tbSIN.Text
        prm10.Value = ""
        prm11.Value = 0

        ' Set up command to call stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "spEmployeeInsert"
        cmd.Parameters.Add(prm0)
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(prm4)
        cmd.Parameters.Add(prm5)
        cmd.Parameters.Add(prm6)
        cmd.Parameters.Add(prm7)
        cmd.Parameters.Add(prm8)
        cmd.Parameters.Add(prm9)
        cmd.Parameters.Add(prm10)
        cmd.Parameters.Add(prm11)

        ' Open connection
        con.Open()

        ' Execute stored proc
        rv = cmd.ExecuteNonQuery()

        ' Process any errors
        If rv = 0 Then
            MsgBox("Failed")
        Else
            con.Close()
            If (lbUser.SelectedItems.Count > 0) And (lbView.SelectedItems.Count > 0) Then
                FillResult()
                tbEmployeeId.Clear() ' Clear auto generated key (represents old Employee that may not exist anymore)
            End If
            Exit Sub
        End If

        ' Close connection
        con.Close()
    End Sub
    Private Sub lblInsertRecord_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblInsertRecord.MouseHover
        ttlblInsertRecord.SetToolTip(lblInsertRecord, "Insert new employee")
    End Sub
    Private Sub lblDeleteRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblDeleteRecord.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim rv As Integer

        Dim prm0 As SqlClient.SqlParameter
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter

        ' Define parameters for stored proc
        prm0 = New SqlClient.SqlParameter("@EmployeeId", SqlDbType.Int)
        prm1 = New SqlClient.SqlParameter("@ERROR_MESSAGE", SqlDbType.VarChar)
        prm1.Direction = ParameterDirection.InputOutput
        prm2 = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        prm2.Direction = ParameterDirection.InputOutput

        ' Set parameters for stored proc
        prm0.Value = tbEmployeeId.Text
        prm1.Value = ""
        prm2.Value = 0

        ' Set up command to call stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "spEmployeeDelete"
        cmd.Parameters.Add(prm0)
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)

        ' Open connection
        con.Open()

        ' Execute stored proc
        rv = cmd.ExecuteNonQuery()

        ' Process any errors
        If rv = 0 Then
            MsgBox("Failed")
        Else
            con.Close()
            If (lbUser.SelectedItems.Count > 0) And (lbView.SelectedItems.Count > 0) Then
                FillResult()
            End If
            lblUpdateRecord.Enabled = False ' Disable update/insert/delete labels (text boxes now represent deleted record)
            lblInsertRecord.Enabled = False
            lblDeleteRecord.Enabled = False
            Exit Sub
        End If

        ' Close connection
        con.Close()
    End Sub
    Private Sub lblDeleteRecord_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblDeleteRecord.MouseHover
        ttlblDeleteRecord.SetToolTip(lblDeleteRecord, "Delete selected employee")
    End Sub
    Private Sub btnTestSecurity_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTestSecurity.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim MySecurity(3) As String
        Dim prm0 As SqlClient.SqlParameter
        Dim prm1 As SqlClient.SqlParameter

        ' Insure that parameter values have been selected for stored proc
        If lbUser.SelectedItems.Count = 0 Then
            MsgBox("Must choose User")
            Exit Sub
        End If

        If lbView.SelectedItems.Count = 0 Then
            MsgBox("Must choose View")
            Exit Sub
        End If

        ' Define parameters for stored proc
        prm0 = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prm1 = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)

        ' Set parameters for stored proc
        prm0.Value = lbUser.SelectedItems.Item(0).ToString
        prm1.Value = lbView.SelectedItems.Item(0).ToString

        ' Set up command to call stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqSecurityColumn"
        cmd.Parameters.Add(prm0)
        cmd.Parameters.Add(prm1)

        ' Open connection
        con.Open()

        ' Clear all constraints from previous test (because some may not be used in current test)
        For Each ctrl As Control In Me.Controls
            ' If this is one of the following controls
            If (TypeOf ctrl Is TextBox) Or _
            (TypeOf ctrl Is Button) Or _
            (TypeOf ctrl Is ListBox) Or _
            (TypeOf ctrl Is ListView) Then
                ctrl.Enabled = True
                ctrl.Visible = True
            End If
        Next

        ' Execute stored proc
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read() ' Loop through constraints for current test
            MySecurity(0) = reader.Item(0).ToString ' ColumnName
            MySecurity(1) = reader.Item(1).ToString ' AccessColumnName
            MySecurity(2) = reader.Item(2).ToString ' Priority (not used)
            For Each ctrl As Control In Me.Controls     ' Loop through all controls
                ' If this is one of the following controls
                If (TypeOf ctrl Is TextBox) Or _
                (TypeOf ctrl Is Button) Or _
                (TypeOf ctrl Is ListBox) Or _
                (TypeOf ctrl Is ListView) Then
                    ' Referenced by current constraint
                    If MySecurity(0).ToUpper = ctrl.Name.ToUpper Then   ' Case sensitivity removed
                        ctrl.Enabled = True             ' Enable it and make it visible
                        ctrl.Visible = True
                        If MySecurity(1) = "Lock" Then  ' Lock it if required
                            ctrl.Enabled = False
                        End If
                        If MySecurity(1) = "Hide" Then  ' Hide it if required
                            ctrl.Visible = False
                        End If
                        If MySecurity(1) = "Full" Then  ' Full access if required
                            ctrl.Enabled = True
                            ctrl.Visible = True
                        End If
                    End If
                End If
            Next
        End While
        reader.Close()

        ' Make sure control representing auto generated Id is still disabled
        tbEmployeeId.Enabled = False

        ' Close connection
        con.Close()
    End Sub
    Private Sub lbControl_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lbControl.Click
        tbControl.Text = lbControl.SelectedItem.ToString
    End Sub
End Class
